/** @file   GfxManager.h
 * @brief   Declaration of GfxManager class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/24 12:24:26 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_GFXMANAGER_H
#define H_WWW_GFXMANAGER_H

#include "WarehouseFactory.h"
#include "eng2d_Exception.h"


// Forward declarations
struct BITMAP;
struct RLE_SPRITE;

namespace eng2d {
  class DataWarehouse;
  class GraphicsContainer;
  class BMFont;
  class Font;
};


namespace WeWantWar {

/** @class  GfxManager
 * @brief
 * @author  Tomi Lamminsaari
 *
 */
class GfxManager
{
public:

  enum FontId {
    ETitleFont,
    EStoryFont
  };
  

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  /** Pointer to menu background image. */
  static BITMAP* titlePic;
  /** Pointer to main font. */
  static eng2d::BMFont* titleFont;
  static eng2d::Font* storyFont;
  static eng2d::Font* ammoFont;
  static eng2d::Font* objectiveFont;



  /** Loads all the graphics.
   * @return  0 if successful. Negative number if fails.
   */
  static int init();
  
  /** Delete all the graphics.
   */
  static void cleanup();
  
  /** Returns the GraphicItem that matches with given uid.
   * @param   aUid              Id of the GraphicsItem being looked for.
   * @return  Pointer to GraphicsItem that matches the uid or nullpointer if
   *          no item was found.
   */
  static eng2d::GraphicsContainer* findGfxContainer( int aUid );
  
  /** Returns the allegro bitmap
   * @param   aUid              Id of the GraphicsItem being looked for.
   * @param   aIndex            index of the bitmap within the matching
   *                            GraphicsItem. Default value is 0.
   * @return  Pointer to Allegro format bitmap.
   */
  static BITMAP* findBitmap( int aUid, int aIndex=0 )
      throw ( eng2d::xOutOfBounds, eng2d::xLogicError );
      
  /** Returns the allegro rle sprite.
   * @param   aUid              Id of the GraphicsItem being looked for.
   * @param   aIndex            index of the rle sprite within the matching
   *                            GraphicsItem. Default value is 0.
   * @return  Pointer to Allegro format RLE_SPRITE.
   */
  static RLE_SPRITE* findRleSprite( int aUid, int aIndex=0 )
      throw ( eng2d::xOutOfBounds, eng2d::xLogicError );

  /** Returns the warehouse object.
   * @return  Pointer to warehouse object.
   */
  static eng2d::DataWarehouse* getWarehouse();  

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  GfxManager();

  /** Destructor
   */
  ~GfxManager();

  /** Copy constructor
   * @param   aAnother          Reference to another GfxManager
   */
  GfxManager( const GfxManager& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another GfxManager
   * @return  Reference to this object.
   */
  GfxManager& operator= ( const GfxManager& aAnother );


  ///
  /// Inherited methods
  /// =================


  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================


protected:
  ///
  /// Data members
  /// ============
  
    /** Pointer to warehouse that contains the graphics of the game. */
  static eng2d::DataWarehouse* allGraphics;

};


class GfxLoadProgressObserver : public eng2d::MWarehouseCreationObserver
{
  /** From MWarehouseCreationObserver
   */
  virtual void NotifyWarehouseCreation( int aCurrentStep, int aTotalSteps,
                                        const std::string& aCurrentFilename );
};


};  // end of namespace

#endif
